<?php
/**
 * Standard text field.
 *
 * @since 1.0.0
 *
 * @extends CMB_Field
 *
 * @package WordPress
 * @subpackage Custom Meta Boxes
 */

class CMB_Text_Field extends CMB_Field {

	/**
	 * Print out field HTML.
	 */
	public function html() {
		?>

		<input type="text" <?php $this->id_attr(); ?> <?php $this->boolean_attr(); ?> <?php $this->class_attr(); ?> <?php $this->name_attr(); ?> placeholder="<?php echo ! empty( $this->args['placeholder'] ) ? esc_attr( $this->args['placeholder'] ) : ''; ?>" value="<?php echo esc_attr( $this->get_value() ); ?>" />

		<?php
	}
}
