<?php
/**
 * Standard text meta box for a URL.
 *
 * @since 1.0.0
 *
 * @extends CMB_Field
 *
 * @package WordPress
 * @subpackage Custom Meta Boxes
 */

class CMB_URL_Field extends CMB_Field {

	/**
	 * Print out field HTML.
	 */
	public function html() {
		?>

		<input type="url" <?php $this->id_attr(); ?> <?php $this->boolean_attr(); ?> <?php $this->class_attr( 'cmb_text_url code' ); ?> <?php $this->name_attr(); ?> placeholder="<?php echo ! empty( $this->args['placeholder'] ) ? esc_attr( $this->args['placeholder'] ) : ''; ?>" value="<?php echo esc_attr( esc_url( $this->value ) ); ?>" />

		<?php
	}
}
